﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Xml.Linq;
using UnityEngine;

public class TerrainConfiguration : ConfigurationElement
{
    public int TerrainChunkWidth { get; private set; }
    public int TerrainChunkHeight { get; private set; }
    public int TerrainNoiseZoneWidth { get; private set; }
    public int TerrainNoiseZoneHeight { get; private set; }
    public bool IsBilinearInterpolationEnabled { get; private set; }

    public TerrainConfiguration() : base("Terrain")
    {

    }

    public override bool Parse(XElement configElem)
    {
        try
        {
            TerrainChunkWidth = Convert.ToInt32(configElem.Element("TerrainChunkWidth").Value);
            TerrainChunkHeight = Convert.ToInt32(configElem.Element("TerrainChunkHeight").Value);
            TerrainNoiseZoneWidth = Convert.ToInt32(configElem.Element("TerrainNoiseZoneWidth").Value);
            TerrainNoiseZoneHeight = Convert.ToInt32(configElem.Element("TerrainNoiseZoneHeight").Value);
            IsBilinearInterpolationEnabled = Convert.ToBoolean(configElem.Element("IsBilinearInterpolationEnabled").Value);
            return true;
        }

        catch (Exception ex)
        {
            Debug.LogError("ERROR: Caught an exception when parsing terrain configuration. The exception is: " + ex);
            Preloader.ExceptionMessage = ex.ToString();
            return false;
        }
    }
}
